@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The instance view of a virtual machine extension handler.
 * @property status The extension handler status.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VirtualMachineExtensionHandlerInstanceViewResponse(
    public val status: InstanceViewStatusResponse? = null,
    public val type: String? = null,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineExtensionHandlerInstanceViewResponse): VirtualMachineExtensionHandlerInstanceViewResponse =
            VirtualMachineExtensionHandlerInstanceViewResponse(
                status = javaType.status().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
