@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a virtual machine extension.
 * @property name The virtual machine extension name.
 * @property statuses The resource status information.
 * @property substatuses The resource status information.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VirtualMachineExtensionInstanceViewResponse(
    public val name: String? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val substatuses: List<InstanceViewStatusResponse>? = null,
    public val type: String? = null,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineExtensionInstanceViewResponse): VirtualMachineExtensionInstanceViewResponse = VirtualMachineExtensionInstanceViewResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            substatuses = javaType.substatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
