@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machines network configuration's DNS settings.
 * @property dnsServers List of DNS servers IP addresses
 */
public data class VirtualMachineNetworkInterfaceDnsSettingsConfigurationResponse(
    public val dnsServers: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineNetworkInterfaceDnsSettingsConfigurationResponse): VirtualMachineNetworkInterfaceDnsSettingsConfigurationResponse =
            VirtualMachineNetworkInterfaceDnsSettingsConfigurationResponse(
                dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            )
    }
}
