@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The status of virtual machine patch operations.
 * @property availablePatchSummary The available patch summary of the latest assessment operation for the virtual machine.
 * @property configurationStatuses The enablement status of the specified patchMode
 * @property lastPatchInstallationSummary The installation summary of the latest installation operation for the virtual machine.
 */
public data class VirtualMachinePatchStatusResponse(
    public val availablePatchSummary: AvailablePatchSummaryResponse? = null,
    public val configurationStatuses: List<InstanceViewStatusResponse>,
    public val lastPatchInstallationSummary: LastPatchInstallationSummaryResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachinePatchStatusResponse): VirtualMachinePatchStatusResponse = VirtualMachinePatchStatusResponse(
            availablePatchSummary = javaType.availablePatchSummary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.AvailablePatchSummaryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            configurationStatuses = javaType.configurationStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            lastPatchInstallationSummary = javaType.lastPatchInstallationSummary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.LastPatchInstallationSummaryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
