@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a virtual machines network configuration's DNS settings.
 * @property domainNameLabel The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
 */
public data class VirtualMachinePublicIPAddressDnsSettingsConfigurationResponse(
    public val domainNameLabel: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationResponse): VirtualMachinePublicIPAddressDnsSettingsConfigurationResponse =
            VirtualMachinePublicIPAddressDnsSettingsConfigurationResponse(
                domainNameLabel = javaType.domainNameLabel(),
            )
    }
}
