@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a virtual machine run command.
 * @property endTime Script end time.
 * @property error Script error stream.
 * @property executionMessage Communicate script configuration errors or execution messages.
 * @property executionState Script execution status.
 * @property exitCode Exit code returned from script execution.
 * @property output Script output stream.
 * @property startTime Script start time.
 * @property statuses The resource status information.
 */
public data class VirtualMachineRunCommandInstanceViewResponse(
    public val endTime: String? = null,
    public val error: String? = null,
    public val executionMessage: String? = null,
    public val executionState: String? = null,
    public val exitCode: Int? = null,
    public val output: String? = null,
    public val startTime: String? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineRunCommandInstanceViewResponse): VirtualMachineRunCommandInstanceViewResponse = VirtualMachineRunCommandInstanceViewResponse(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 -> args0 }).orElse(null),
            executionMessage = javaType.executionMessage().map({ args0 -> args0 }).orElse(null),
            executionState = javaType.executionState().map({ args0 -> args0 }).orElse(null),
            exitCode = javaType.exitCode().map({ args0 -> args0 }).orElse(null),
            output = javaType.output().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
