@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a virtual machine scale set data disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption The create option.
 * @property deleteOption Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.
 * @property diskIOPSReadWrite Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
 * @property diskMBpsReadWrite Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class VirtualMachineScaleSetDataDiskResponse(
    public val caching: String? = null,
    public val createOption: String,
    public val deleteOption: String? = null,
    public val diskIOPSReadWrite: Double? = null,
    public val diskMBpsReadWrite: Double? = null,
    public val diskSizeGB: Int? = null,
    public val lun: Int,
    public val managedDisk: VirtualMachineScaleSetManagedDiskParametersResponse? = null,
    public val name: String? = null,
    public val writeAcceleratorEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetDataDiskResponse): VirtualMachineScaleSetDataDiskResponse = VirtualMachineScaleSetDataDiskResponse(
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            createOption = javaType.createOption(),
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            diskIOPSReadWrite = javaType.diskIOPSReadWrite().map({ args0 -> args0 }).orElse(null),
            diskMBpsReadWrite = javaType.diskMBpsReadWrite().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            lun = javaType.lun(),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetManagedDiskParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            writeAcceleratorEnabled = javaType.writeAcceleratorEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
