@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set extension profile.
 * @property extensions The virtual machine scale set child extension resources.
 * @property extensionsTimeBudget Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
 */
public data class VirtualMachineScaleSetExtensionProfileResponse(
    public val extensions: List<VirtualMachineScaleSetExtensionResponse>? = null,
    public val extensionsTimeBudget: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetExtensionProfileResponse): VirtualMachineScaleSetExtensionProfileResponse =
            VirtualMachineScaleSetExtensionProfileResponse(
                extensions = javaType.extensions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetExtensionResponse.Companion.toKotlin(args0)
                    })
                }),
                extensionsTimeBudget = javaType.extensionsTimeBudget().map({ args0 -> args0 }).orElse(null),
            )
    }
}
