@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress

/**
 * Specifies the hardware settings for the virtual machine scale set.
 * @property vmSizeProperties Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
 */
public data class VirtualMachineScaleSetHardwareProfileResponse(
    public val vmSizeProperties: VMSizePropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetHardwareProfileResponse): VirtualMachineScaleSetHardwareProfileResponse =
            VirtualMachineScaleSetHardwareProfileResponse(
                vmSizeProperties = javaType.vmSizeProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.VMSizePropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
