@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set network profile's IP configuration.
 * @property applicationGatewayBackendAddressPools Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
 * @property applicationSecurityGroups Specifies an array of references to application security group.
 * @property loadBalancerBackendAddressPools Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
 * @property loadBalancerInboundNatPools Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
 * @property name The IP configuration name.
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 * @property privateIPAddressVersion Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
 * @property publicIPAddressConfiguration The publicIPAddressConfiguration.
 * @property subnet Specifies the identifier of the subnet.
 */
public data class VirtualMachineScaleSetIPConfigurationResponse(
    public val applicationGatewayBackendAddressPools: List<SubResourceResponse>? = null,
    public val applicationSecurityGroups: List<SubResourceResponse>? = null,
    public val loadBalancerBackendAddressPools: List<SubResourceResponse>? = null,
    public val loadBalancerInboundNatPools: List<SubResourceResponse>? = null,
    public val name: String,
    public val primary: Boolean? = null,
    public val privateIPAddressVersion: String? = null,
    public val publicIPAddressConfiguration: VirtualMachineScaleSetPublicIPAddressConfigurationResponse? = null,
    public val subnet: ApiEntityReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetIPConfigurationResponse): VirtualMachineScaleSetIPConfigurationResponse =
            VirtualMachineScaleSetIPConfigurationResponse(
                applicationGatewayBackendAddressPools = javaType.applicationGatewayBackendAddressPools().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                applicationSecurityGroups = javaType.applicationSecurityGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                loadBalancerBackendAddressPools = javaType.loadBalancerBackendAddressPools().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                loadBalancerInboundNatPools = javaType.loadBalancerInboundNatPools().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
                privateIPAddressVersion = javaType.privateIPAddressVersion().map({ args0 -> args0 }).orElse(null),
                publicIPAddressConfiguration = javaType.publicIPAddressConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetPublicIPAddressConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                subnet = javaType.subnet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
