@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains the IP tag associated with the public IP address.
 * @property ipTagType IP tag type. Example: FirstPartyUsage.
 * @property tag IP tag associated with the public IP. Example: SQL, Storage etc.
 */
public data class VirtualMachineScaleSetIpTagResponse(
    public val ipTagType: String? = null,
    public val tag: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetIpTagResponse): VirtualMachineScaleSetIpTagResponse = VirtualMachineScaleSetIpTagResponse(
            ipTagType = javaType.ipTagType().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
        )
    }
}
