@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set operating system disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
 * @property deleteOption Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
 * @property diffDiskSettings Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property image Specifies information about the unmanaged user image to base the scale set on.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property osType This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 * @property vhdContainers Specifies the container urls that are used to store operating system disks for the scale set.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class VirtualMachineScaleSetOSDiskResponse(
    public val caching: String? = null,
    public val createOption: String,
    public val deleteOption: String? = null,
    public val diffDiskSettings: DiffDiskSettingsResponse? = null,
    public val diskSizeGB: Int? = null,
    public val image: VirtualHardDiskResponse? = null,
    public val managedDisk: VirtualMachineScaleSetManagedDiskParametersResponse? = null,
    public val name: String? = null,
    public val osType: String? = null,
    public val vhdContainers: List<String>? = null,
    public val writeAcceleratorEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetOSDiskResponse): VirtualMachineScaleSetOSDiskResponse = VirtualMachineScaleSetOSDiskResponse(
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            createOption = javaType.createOption(),
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            diffDiskSettings = javaType.diffDiskSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiffDiskSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualHardDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetManagedDiskParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            vhdContainers = javaType.vhdContainers().map({ args0 -> args0 }),
            writeAcceleratorEnabled = javaType.writeAcceleratorEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
