@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set OS profile.
 * @property adminPassword Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
 * @property adminUsername Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
 * @property allowExtensionOperations Specifies whether extension operations should be allowed on the virtual machine scale set. This may only be set to False when no extensions are present on the virtual machine scale set.
 * @property computerNamePrefix Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
 * @property customData Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
 * @property linuxConfiguration Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
 * @property requireGuestProvisionSignal Optional property which must either be set to True or omitted.
 * @property secrets Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
 * @property windowsConfiguration Specifies Windows operating system settings on the virtual machine.
 */
public data class VirtualMachineScaleSetOSProfileResponse(
    public val adminPassword: String? = null,
    public val adminUsername: String? = null,
    public val allowExtensionOperations: Boolean? = null,
    public val computerNamePrefix: String? = null,
    public val customData: String? = null,
    public val linuxConfiguration: LinuxConfigurationResponse? = null,
    public val requireGuestProvisionSignal: Boolean? = null,
    public val secrets: List<VaultSecretGroupResponse>? = null,
    public val windowsConfiguration: WindowsConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetOSProfileResponse): VirtualMachineScaleSetOSProfileResponse = VirtualMachineScaleSetOSProfileResponse(
            adminPassword = javaType.adminPassword().map({ args0 -> args0 }).orElse(null),
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            allowExtensionOperations = javaType.allowExtensionOperations().map({ args0 -> args0 }).orElse(null),
            computerNamePrefix = javaType.computerNamePrefix().map({ args0 -> args0 }).orElse(null),
            customData = javaType.customData().map({ args0 -> args0 }).orElse(null),
            linuxConfiguration = javaType.linuxConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.LinuxConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requireGuestProvisionSignal = javaType.requireGuestProvisionSignal().map({ args0 ->
                args0
            }).orElse(null),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VaultSecretGroupResponse.Companion.toKotlin(args0)
                })
            }),
            windowsConfiguration = javaType.windowsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.WindowsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
