@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set storage profile.
 * @property dataDisks Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property diskControllerType
 * @property imageReference Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
 * @property osDisk Specifies information about the operating system disk used by the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 */
public data class VirtualMachineScaleSetStorageProfileResponse(
    public val dataDisks: List<VirtualMachineScaleSetDataDiskResponse>? = null,
    public val diskControllerType: List<String>? = null,
    public val imageReference: ImageReferenceResponse? = null,
    public val osDisk: VirtualMachineScaleSetOSDiskResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetStorageProfileResponse): VirtualMachineScaleSetStorageProfileResponse = VirtualMachineScaleSetStorageProfileResponse(
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetDataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            diskControllerType = javaType.diskControllerType().map({ args0 -> args0 }),
            imageReference = javaType.imageReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osDisk = javaType.osDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetOSDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
