@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a virtual machine scale set virtual machine profile.
 * @property applicationProfile Specifies the gallery applications that should be made available to the VM/VMSS
 * @property billingProfile Specifies the billing related details of a Azure Spot VMSS. Minimum api-version: 2019-03-01.
 * @property capacityReservation Specifies the capacity reservation related details of a scale set. Minimum api-version: 2021-04-01.
 * @property diagnosticsProfile Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property evictionPolicy Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
 * @property extensionProfile Specifies a collection of settings for extensions installed on virtual machines in the scale set.
 * @property hardwareProfile Specifies the hardware profile related details of a scale set. Minimum api-version: 2021-11-01.
 * @property licenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
 * @property networkProfile Specifies properties of the network interfaces of the virtual machines in the scale set.
 * @property osProfile Specifies the operating system settings for the virtual machines in the scale set.
 * @property priority Specifies the priority for the virtual machines in the scale set. Minimum api-version: 2017-10-30-preview.
 * @property scheduledEventsProfile Specifies Scheduled Event related configurations.
 * @property securityPostureReference Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
 * @property securityProfile Specifies the Security related profile settings for the virtual machines in the scale set.
 * @property serviceArtifactReference Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property userData UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
 */
public data class VirtualMachineScaleSetVMProfileResponse(
    public val applicationProfile: ApplicationProfileResponse? = null,
    public val billingProfile: BillingProfileResponse? = null,
    public val capacityReservation: CapacityReservationProfileResponse? = null,
    public val diagnosticsProfile: DiagnosticsProfileResponse? = null,
    public val evictionPolicy: String? = null,
    public val extensionProfile: VirtualMachineScaleSetExtensionProfileResponse? = null,
    public val hardwareProfile: VirtualMachineScaleSetHardwareProfileResponse? = null,
    public val licenseType: String? = null,
    public val networkProfile: VirtualMachineScaleSetNetworkProfileResponse? = null,
    public val osProfile: VirtualMachineScaleSetOSProfileResponse? = null,
    public val priority: String? = null,
    public val scheduledEventsProfile: ScheduledEventsProfileResponse? = null,
    public val securityPostureReference: SecurityPostureReferenceResponse? = null,
    public val securityProfile: SecurityProfileResponse? = null,
    public val serviceArtifactReference: ServiceArtifactReferenceResponse? = null,
    public val storageProfile: VirtualMachineScaleSetStorageProfileResponse? = null,
    public val userData: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetVMProfileResponse): VirtualMachineScaleSetVMProfileResponse = VirtualMachineScaleSetVMProfileResponse(
            applicationProfile = javaType.applicationProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApplicationProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            billingProfile = javaType.billingProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.BillingProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            capacityReservation = javaType.capacityReservation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diagnosticsProfile = javaType.diagnosticsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            evictionPolicy = javaType.evictionPolicy().map({ args0 -> args0 }).orElse(null),
            extensionProfile = javaType.extensionProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetExtensionProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetHardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetNetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetOSProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            scheduledEventsProfile = javaType.scheduledEventsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ScheduledEventsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityPostureReference = javaType.securityPostureReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SecurityPostureReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceArtifactReference = javaType.serviceArtifactReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ServiceArtifactReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetStorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userData = javaType.userData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
