@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies additional settings to be applied when patch mode AutomaticByPlatform is selected in Windows patch settings.
 * @property bypassPlatformSafetyChecksOnUserSchedule Enables customer to schedule patching without accidental upgrades
 * @property rebootSetting Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
 */
public data class WindowsVMGuestPatchAutomaticByPlatformSettingsResponse(
    public val bypassPlatformSafetyChecksOnUserSchedule: Boolean? = null,
    public val rebootSetting: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.WindowsVMGuestPatchAutomaticByPlatformSettingsResponse): WindowsVMGuestPatchAutomaticByPlatformSettingsResponse =
            WindowsVMGuestPatchAutomaticByPlatformSettingsResponse(
                bypassPlatformSafetyChecksOnUserSchedule = javaType.bypassPlatformSafetyChecksOnUserSchedule().map({ args0 ->
                    args0
                }).orElse(null),
                rebootSetting = javaType.rebootSetting().map({ args0 -> args0 }).orElse(null),
            )
    }
}
