@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.AADBasedSecurityPrincipalArgs.builder
import com.pulumi.azurenative.confidentialledger.kotlin.enums.LedgerRoleName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AAD based security principal with associated Ledger RoleName
 * @property ledgerRoleName LedgerRole associated with the Security Principal of Ledger
 * @property principalId UUID/GUID based Principal Id of the Security Principal
 * @property tenantId UUID/GUID based Tenant Id of the Security Principal
 */
public data class AADBasedSecurityPrincipalArgs(
    public val ledgerRoleName: Output<Either<String, LedgerRoleName>>? = null,
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.AADBasedSecurityPrincipalArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.inputs.AADBasedSecurityPrincipalArgs =
        com.pulumi.azurenative.confidentialledger.inputs.AADBasedSecurityPrincipalArgs.builder()
            .ledgerRoleName(
                ledgerRoleName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AADBasedSecurityPrincipalArgs].
 */
@PulumiTagMarker
public class AADBasedSecurityPrincipalArgsBuilder internal constructor() {
    private var ledgerRoleName: Output<Either<String, LedgerRoleName>>? = null

    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("seecafapvwipfnqy")
    public suspend fun ledgerRoleName(`value`: Output<Either<String, LedgerRoleName>>) {
        this.ledgerRoleName = value
    }

    /**
     * @param value UUID/GUID based Principal Id of the Security Principal
     */
    @JvmName("itpghmyjwjxyhorh")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value UUID/GUID based Tenant Id of the Security Principal
     */
    @JvmName("wpbypxxmlycqrtdt")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("jadwownratgtqjhf")
    public suspend fun ledgerRoleName(`value`: Either<String, LedgerRoleName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ledgerRoleName = mapped
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("qvlqvsqreekievex")
    public fun ledgerRoleName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LedgerRoleName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ledgerRoleName = mapped
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("nwtkfupiisidtjia")
    public fun ledgerRoleName(`value`: LedgerRoleName) {
        val toBeMapped = Either.ofRight<String, LedgerRoleName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ledgerRoleName = mapped
    }

    /**
     * @param value UUID/GUID based Principal Id of the Security Principal
     */
    @JvmName("elqhfrevdxhgbnxd")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value UUID/GUID based Tenant Id of the Security Principal
     */
    @JvmName("nsyqcdlckjlrlxjh")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AADBasedSecurityPrincipalArgs = AADBasedSecurityPrincipalArgs(
        ledgerRoleName = ledgerRoleName,
        principalId = principalId,
        tenantId = tenantId,
    )
}
