@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.GetManagedCCFPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appName Name of the Managed CCF
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetManagedCCFPlainArgs(
    public val appName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.GetManagedCCFPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.inputs.GetManagedCCFPlainArgs =
        com.pulumi.azurenative.confidentialledger.inputs.GetManagedCCFPlainArgs.builder()
            .appName(appName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedCCFPlainArgs].
 */
@PulumiTagMarker
public class GetManagedCCFPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Managed CCF
     */
    @JvmName("peyopqfgfgnlkdft")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("abcctpeirjmfogqv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedCCFPlainArgs = GetManagedCCFPlainArgs(
        appName = appName ?: throw PulumiNullFieldException("appName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
