@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cert based security principal with Ledger RoleName
 * @property cert Public key of the user cert (.pem or .cer)
 * @property ledgerRoleName LedgerRole associated with the Security Principal of Ledger
 */
public data class CertBasedSecurityPrincipalResponse(
    public val cert: String? = null,
    public val ledgerRoleName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.CertBasedSecurityPrincipalResponse): CertBasedSecurityPrincipalResponse = CertBasedSecurityPrincipalResponse(
            cert = javaType.cert().map({ args0 -> args0 }).orElse(null),
            ledgerRoleName = javaType.ledgerRoleName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
