@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Confidential Ledger. Contains the properties of Confidential Ledger Resource.
 * @property id Fully qualified resource Id for the resource.
 * @property location The Azure location where the Confidential Ledger is running.
 * @property name Name of the Resource.
 * @property properties Properties of Confidential Ledger Resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Additional tags for Confidential Ledger
 * @property type The type of the resource.
 */
public data class GetLedgerResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: LedgerPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.GetLedgerResult): GetLedgerResult = GetLedgerResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.confidentialledger.kotlin.outputs.LedgerPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.confidentialledger.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
