@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Additional Confidential Ledger properties.
 * @property aadBasedSecurityPrincipals Array of all AAD based Security Principals.
 * @property certBasedSecurityPrincipals Array of all cert based Security Principals.
 * @property identityServiceUri Endpoint for accessing network identity.
 * @property ledgerInternalNamespace Internal namespace for the Ledger
 * @property ledgerName Unique name for the Confidential Ledger.
 * @property ledgerType Type of Confidential Ledger
 * @property ledgerUri Endpoint for calling Ledger Service.
 * @property provisioningState Provisioning state of Ledger Resource
 */
public data class LedgerPropertiesResponse(
    public val aadBasedSecurityPrincipals: List<AADBasedSecurityPrincipalResponse>? = null,
    public val certBasedSecurityPrincipals: List<CertBasedSecurityPrincipalResponse>? = null,
    public val identityServiceUri: String,
    public val ledgerInternalNamespace: String,
    public val ledgerName: String,
    public val ledgerType: String? = null,
    public val ledgerUri: String,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.LedgerPropertiesResponse): LedgerPropertiesResponse = LedgerPropertiesResponse(
            aadBasedSecurityPrincipals = javaType.aadBasedSecurityPrincipals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confidentialledger.kotlin.outputs.AADBasedSecurityPrincipalResponse.Companion.toKotlin(args0)
                })
            }),
            certBasedSecurityPrincipals = javaType.certBasedSecurityPrincipals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confidentialledger.kotlin.outputs.CertBasedSecurityPrincipalResponse.Companion.toKotlin(args0)
                })
            }),
            identityServiceUri = javaType.identityServiceUri(),
            ledgerInternalNamespace = javaType.ledgerInternalNamespace(),
            ledgerName = javaType.ledgerName(),
            ledgerType = javaType.ledgerType().map({ args0 -> args0 }).orElse(null),
            ledgerUri = javaType.ledgerUri(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
