@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Additional Managed CCF properties.
 * @property appName Unique name for the Managed CCF.
 * @property appUri Endpoint for calling Managed CCF Service.
 * @property deploymentType Deployment Type of Managed CCF
 * @property identityServiceUri Endpoint for accessing network identity.
 * @property memberIdentityCertificates List of member identity certificates for  Managed CCF
 * @property nodeCount Number of CCF nodes in the Managed CCF.
 * @property provisioningState Provisioning state of Ledger Resource
 */
public data class ManagedCCFPropertiesResponse(
    public val appName: String,
    public val appUri: String,
    public val deploymentType: DeploymentTypeResponse? = null,
    public val identityServiceUri: String,
    public val memberIdentityCertificates: List<MemberIdentityCertificateResponse>? = null,
    public val nodeCount: Int? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.ManagedCCFPropertiesResponse): ManagedCCFPropertiesResponse = ManagedCCFPropertiesResponse(
            appName = javaType.appName(),
            appUri = javaType.appUri(),
            deploymentType = javaType.deploymentType().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confidentialledger.kotlin.outputs.DeploymentTypeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identityServiceUri = javaType.identityServiceUri(),
            memberIdentityCertificates = javaType.memberIdentityCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confidentialledger.kotlin.outputs.MemberIdentityCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
