@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Object representing MemberIdentityCertificate for Managed CCF.
 * @property certificate Member Identity Certificate
 * @property encryptionkey Member Identity Certificate Encryption Key
 * @property tags
 */
public data class MemberIdentityCertificateResponse(
    public val certificate: String? = null,
    public val encryptionkey: String? = null,
    public val tags: List<CertificateTagsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.MemberIdentityCertificateResponse): MemberIdentityCertificateResponse = MemberIdentityCertificateResponse(
            certificate = javaType.certificate().map({ args0 -> args0 }).orElse(null),
            encryptionkey = javaType.encryptionkey().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confidentialledger.kotlin.outputs.CertificateTagsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
