@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Record of the environment
 * @property displayName Display name of the user
 * @property id Id of the environment
 * @property kind Type of environment
 * @property metadata Metadata of the record
 */
public data class EnvironmentRecordResponse(
    public val displayName: String? = null,
    public val id: String? = null,
    public val kind: String? = null,
    public val metadata: MetadataEntityResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.EnvironmentRecordResponse): EnvironmentRecordResponse = EnvironmentRecordResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.MetadataEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
