@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Confluent Offer detail
 * @property id Offer Id
 * @property planId Offer Plan Id
 * @property planName Offer Plan Name
 * @property publisherId Publisher Id
 * @property status SaaS Offer Status
 * @property termUnit Offer Plan Term unit
 */
public data class OfferDetailResponse(
    public val id: String,
    public val planId: String,
    public val planName: String,
    public val publisherId: String,
    public val status: String,
    public val termUnit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.OfferDetailResponse): OfferDetailResponse = OfferDetailResponse(
            id = javaType.id(),
            planId = javaType.planId(),
            planName = javaType.planName(),
            publisherId = javaType.publisherId(),
            status = javaType.status(),
            termUnit = javaType.termUnit(),
        )
    }
}
