@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Record of the service account
 * @property description Description of the service account
 * @property displayName Name of the service account
 * @property id Id of the service account
 * @property kind Type of account
 * @property metadata Metadata of the record
 */
public data class ServiceAccountRecordResponse(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String? = null,
    public val kind: String? = null,
    public val metadata: MetadataEntityResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ServiceAccountRecordResponse): ServiceAccountRecordResponse = ServiceAccountRecordResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.MetadataEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
