@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Record of the user
 * @property authType Auth type of the user
 * @property email Email of the user
 * @property fullName Name of the user
 * @property id Id of the user
 * @property kind Type of account
 * @property metadata Metadata of the record
 */
public data class UserRecordResponse(
    public val authType: String? = null,
    public val email: String? = null,
    public val fullName: String? = null,
    public val id: String? = null,
    public val kind: String? = null,
    public val metadata: MetadataEntityResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.UserRecordResponse): UserRecordResponse = UserRecordResponse(
            authType = javaType.authType().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            fullName = javaType.fullName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.MetadataEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
