@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.ClusterArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the cluster.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-10-01, 2023-12-01.
 * ## Example Usage
 * ### CreateCluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.ConnectedVMwarevSphere.Cluster("cluster", new()
 *     {
 *         ClusterName = "HRCluster",
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         MoRefId = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         ResourceGroupName = "testrg",
 *         VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewCluster(ctx, "cluster", &connectedvmwarevsphere.ClusterArgs{
 * 			ClusterName: pulumi.String("HRCluster"),
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			MoRefId:           pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VCenterId:         pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.Cluster;
 * import com.pulumi.azurenative.connectedvmwarevsphere.ClusterArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("HRCluster")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .location("East US")
 *             .moRefId("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .resourceGroupName("testrg")
 *             .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:Cluster HRCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/clusters/{clusterName}
 * ```
 * @property clusterName Name of the cluster.
 * @property extendedLocation Gets or sets the extended location.
 * @property inventoryItemId Gets or sets the inventory Item ID for the cluster.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
 * @property resourceGroupName The Resource Group Name.
 * @property tags Gets or sets the Resource tags.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this cluster resides.
 */
public data class ClusterArgs(
    public val clusterName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val moRefId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vCenterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.ClusterArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.ClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .moRefId(moRefId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vCenterId(vCenterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var inventoryItemId: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var moRefId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vCenterId: Output<String>? = null

    /**
     * @param value Name of the cluster.
     */
    @JvmName("xiyixmlhovklefqa")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("fjltxnhuerfkttkp")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the cluster.
     */
    @JvmName("rmebcoravhrwicuw")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("senqcjcljyavkjbk")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("rtehceqhgiegrrrp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
     */
    @JvmName("vpnacafcwpsdxexb")
    public suspend fun moRefId(`value`: Output<String>) {
        this.moRefId = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("itudlpvdrmrrnoan")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("jrwhqukaghcytwhj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this cluster resides.
     */
    @JvmName("swxmwiqcrhiwgllf")
    public suspend fun vCenterId(`value`: Output<String>) {
        this.vCenterId = value
    }

    /**
     * @param value Name of the cluster.
     */
    @JvmName("ekvhnxksbdybcshh")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("jhguoivbadwsedny")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Gets or sets the extended location.
     */
    @JvmName("xtwsnsqmqeunxbce")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the cluster.
     */
    @JvmName("shfvqswgxhimxfro")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("aeyvvfopejokgxqc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("funpvydlsirudgny")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
     */
    @JvmName("jwglgiphmllaahyu")
    public suspend fun moRefId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moRefId = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("dbnpjbngmibqgijo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("cgnkmsdrqdnudpdq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("gtcgtibeakylbupb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this cluster resides.
     */
    @JvmName("likokrbiuormmefj")
    public suspend fun vCenterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCenterId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        clusterName = clusterName,
        extendedLocation = extendedLocation,
        inventoryItemId = inventoryItemId,
        kind = kind,
        location = location,
        moRefId = moRefId,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vCenterId = vCenterId,
    )
}
