@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.VirtualDiskResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin as resourceStatusResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin as virtualDiskResponseToKotlin

/**
 * Builder for [VirtualMachineTemplate].
 */
@PulumiTagMarker
public class VirtualMachineTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineTemplateArgs = VirtualMachineTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineTemplateArgsBuilder.() -> Unit) {
        val builder = VirtualMachineTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineTemplate {
        val builtJavaResource =
            com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineTemplate(builtJavaResource)
    }
}

/**
 * Define the virtualMachineTemplate.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-10-01, 2023-12-01.
 * ## Example Usage
 * ### CreateVirtualMachineTemplate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineTemplate = new AzureNative.ConnectedVMwarevSphere.VirtualMachineTemplate("virtualMachineTemplate", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         MoRefId = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         ResourceGroupName = "testrg",
 *         VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *         VirtualMachineTemplateName = "WebFrontEndTemplate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVirtualMachineTemplate(ctx, "virtualMachineTemplate", &connectedvmwarevsphere.VirtualMachineTemplateArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:                   pulumi.String("East US"),
 * 			MoRefId:                    pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			VCenterId:                  pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 			VirtualMachineTemplateName: pulumi.String("WebFrontEndTemplate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineTemplate;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineTemplateArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineTemplate = new VirtualMachineTemplate("virtualMachineTemplate", VirtualMachineTemplateArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .location("East US")
 *             .moRefId("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .resourceGroupName("testrg")
 *             .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *             .virtualMachineTemplateName("WebFrontEndTemplate")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VirtualMachineTemplate WebFrontEndTemplate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineTemplates/{virtualMachineTemplateName}
 * ```
 */
public class VirtualMachineTemplate internal constructor(
    override val javaResource: com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineTemplate,
) : KotlinCustomResource(javaResource, VirtualMachineTemplateMapper) {
    /**
     * Gets the name of the corresponding resource in Kubernetes.
     */
    public val customResourceName: Output<String>
        get() = javaResource.customResourceName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the disks the template.
     */
    public val disks: Output<List<VirtualDiskResponse>>
        get() = javaResource.disks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualDiskResponseToKotlin(args0)
                })
            })
        })

    /**
     * Gets or sets the extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Firmware type
     */
    public val firmwareType: Output<String>
        get() = javaResource.firmwareType().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the folder path of the template.
     */
    public val folderPath: Output<String>
        get() = javaResource.folderPath().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the inventory Item ID for the virtual machine template.
     */
    public val inventoryItemId: Output<String>?
        get() = javaResource.inventoryItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets or sets memory size in MBs for the template.
     */
    public val memorySizeMB: Output<Int>
        get() = javaResource.memorySizeMB().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the vCenter Managed Object name for the virtual machine template.
     */
    public val moName: Output<String>
        get() = javaResource.moName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine
     * template.
     */
    public val moRefId: Output<String>?
        get() = javaResource.moRefId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the network interfaces of the template.
     */
    public val networkInterfaces: Output<List<NetworkInterfaceResponse>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * Gets or sets the number of vCPUs for the template.
     */
    public val numCPUs: Output<Int>
        get() = javaResource.numCPUs().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the number of cores per socket for the template.
     * Defaults to 1 if unspecified.
     */
    public val numCoresPerSocket: Output<Int>
        get() = javaResource.numCoresPerSocket().applyValue({ args0 -> args0 })

    /**
     * Gets or sets os name.
     */
    public val osName: Output<String>
        get() = javaResource.osName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the type of the os.
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource status information.
     */
    public val statuses: Output<List<ResourceStatusResponse>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceStatusResponseToKotlin(args0)
                })
            })
        })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the current version of VMware Tools.
     */
    public val toolsVersion: Output<String>
        get() = javaResource.toolsVersion().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the current version status of VMware Tools installed in the guest operating system.
     */
    public val toolsVersionStatus: Output<String>
        get() = javaResource.toolsVersionStatus().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a unique identifier for this resource.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the ARM Id of the vCenter resource in which this template resides.
     */
    public val vCenterId: Output<String>?
        get() = javaResource.vCenterId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object VirtualMachineTemplateMapper : ResourceMapper<VirtualMachineTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineTemplate::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineTemplate =
        VirtualMachineTemplate(
            javaResource as
                com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineTemplate,
        )
}

/**
 * @see [VirtualMachineTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineTemplate].
 */
public suspend fun virtualMachineTemplate(
    name: String,
    block: suspend VirtualMachineTemplateResourceBuilder.() -> Unit,
): VirtualMachineTemplate {
    val builder = VirtualMachineTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineTemplate(name: String): VirtualMachineTemplate {
    val builder = VirtualMachineTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
