@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin as resourceStatusResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VirtualNetwork].
 */
@PulumiTagMarker
public class VirtualNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkArgs = VirtualNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.connectedvmwarevsphere.VirtualNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetwork(builtJavaResource)
    }
}

/**
 * Define the virtualNetwork.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-10-01, 2023-12-01.
 * ## Example Usage
 * ### CreateVirtualNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.ConnectedVMwarevSphere.VirtualNetwork("virtualNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         MoRefId = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         ResourceGroupName = "testrg",
 *         VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *         VirtualNetworkName = "ProdNetwork",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVirtualNetwork(ctx, "virtualNetwork", &connectedvmwarevsphere.VirtualNetworkArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:           pulumi.String("East US"),
 * 			MoRefId:            pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			VCenterId:          pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 			VirtualNetworkName: pulumi.String("ProdNetwork"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualNetwork;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualNetworkArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .location("East US")
 *             .moRefId("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .resourceGroupName("testrg")
 *             .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *             .virtualNetworkName("ProdNetwork")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VirtualNetwork ProdNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualNetworks/{virtualNetworkName}
 * ```
 */
public class VirtualNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.connectedvmwarevsphere.VirtualNetwork,
) : KotlinCustomResource(javaResource, VirtualNetworkMapper) {
    /**
     * Gets the name of the corresponding resource in Kubernetes.
     */
    public val customResourceName: Output<String>
        get() = javaResource.customResourceName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets the inventory Item ID for the virtual network.
     */
    public val inventoryItemId: Output<String>?
        get() = javaResource.inventoryItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the vCenter Managed Object name for the virtual network.
     */
    public val moName: Output<String>
        get() = javaResource.moName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual network.
     */
    public val moRefId: Output<String>?
        get() = javaResource.moRefId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource status information.
     */
    public val statuses: Output<List<ResourceStatusResponse>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceStatusResponseToKotlin(args0)
                })
            })
        })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a unique identifier for this resource.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the ARM Id of the vCenter resource in which this template resides.
     */
    public val vCenterId: Output<String>?
        get() = javaResource.vCenterId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object VirtualNetworkMapper : ResourceMapper<VirtualNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.connectedvmwarevsphere.VirtualNetwork::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetwork = VirtualNetwork(
        javaResource as
            com.pulumi.azurenative.connectedvmwarevsphere.VirtualNetwork,
    )
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetwork].
 */
public suspend fun virtualNetwork(
    name: String,
    block: suspend VirtualNetworkResourceBuilder.() -> Unit,
): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetwork(name: String): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
