@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetGuestAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the GuestAgent.
 * @property resourceGroupName The Resource Group Name.
 * @property virtualMachineName Name of the vm.
 */
public data class GetGuestAgentPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetGuestAgentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetGuestAgentPlainArgs = com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetGuestAgentPlainArgs.builder()
        .name(name.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestAgentPlainArgs].
 */
@PulumiTagMarker
public class GetGuestAgentPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value Name of the GuestAgent.
     */
    @JvmName("ueuciqeamuntogvp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("itqsxpmyoaeecxns")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("daurdegtgrursjuk")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetGuestAgentPlainArgs = GetGuestAgentPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
