@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHostPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName Name of the host.
 * @property resourceGroupName The Resource Group Name.
 */
public data class GetHostPlainArgs(
    public val hostName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHostPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHostPlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHostPlainArgs.builder()
            .hostName(hostName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostPlainArgs].
 */
@PulumiTagMarker
public class GetHostPlainArgsBuilder internal constructor() {
    private var hostName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the host.
     */
    @JvmName("yfymuynbwgwrtppy")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("fgihtvpheorjtbou")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHostPlainArgs = GetHostPlainArgs(
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
