@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHybridIdentityMetadatumPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataName Name of the HybridIdentityMetadata.
 * @property resourceGroupName The Resource Group Name.
 * @property virtualMachineName Name of the vm.
 */
public data class GetHybridIdentityMetadatumPlainArgs(
    public val metadataName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHybridIdentityMetadatumPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHybridIdentityMetadatumPlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetHybridIdentityMetadatumPlainArgs.builder()
            .metadataName(metadataName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridIdentityMetadatumPlainArgs].
 */
@PulumiTagMarker
public class GetHybridIdentityMetadatumPlainArgsBuilder internal constructor() {
    private var metadataName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value Name of the HybridIdentityMetadata.
     */
    @JvmName("astoghrtnbdigshm")
    public suspend fun metadataName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metadataName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("brojgpmauwdyllaf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("avmjgxhrwxabtsum")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetHybridIdentityMetadatumPlainArgs = GetHybridIdentityMetadatumPlainArgs(
        metadataName = metadataName ?: throw PulumiNullFieldException("metadataName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
