@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetInventoryItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inventoryItemName Name of the inventoryItem.
 * @property resourceGroupName The Resource Group Name.
 * @property vcenterName Name of the vCenter.
 */
public data class GetInventoryItemPlainArgs(
    public val inventoryItemName: String,
    public val resourceGroupName: String,
    public val vcenterName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetInventoryItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetInventoryItemPlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetInventoryItemPlainArgs.builder()
            .inventoryItemName(inventoryItemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vcenterName(vcenterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInventoryItemPlainArgs].
 */
@PulumiTagMarker
public class GetInventoryItemPlainArgsBuilder internal constructor() {
    private var inventoryItemName: String? = null

    private var resourceGroupName: String? = null

    private var vcenterName: String? = null

    /**
     * @param value Name of the inventoryItem.
     */
    @JvmName("ppjvixdyscdstqdc")
    public suspend fun inventoryItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inventoryItemName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("odqghdvfqsxdqhnn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vCenter.
     */
    @JvmName("cmcjclxuijyuenmg")
    public suspend fun vcenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vcenterName = mapped
    }

    internal fun build(): GetInventoryItemPlainArgs = GetInventoryItemPlainArgs(
        inventoryItemName = inventoryItemName ?: throw PulumiNullFieldException("inventoryItemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vcenterName = vcenterName ?: throw PulumiNullFieldException("vcenterName"),
    )
}
