@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetMachineExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property extensionName The name of the machine extension.
 * @property resourceGroupName The Resource Group Name.
 * @property virtualMachineName The name of the machine containing the extension.
 */
public data class GetMachineExtensionPlainArgs(
    public val extensionName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetMachineExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetMachineExtensionPlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetMachineExtensionPlainArgs.builder()
            .extensionName(extensionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetMachineExtensionPlainArgsBuilder internal constructor() {
    private var extensionName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("sqmmauccwwnqpeup")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("nybvwvjabjjhxlok")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the machine containing the extension.
     */
    @JvmName("ourhdfsahjuiqyjw")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetMachineExtensionPlainArgs = GetMachineExtensionPlainArgs(
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
