@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkInterfaceArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.NICType
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.PowerOnBootOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Network Interface model
 * @property deviceKey Gets or sets the device key value.
 * @property ipSettings Gets or sets the ipsettings.
 * @property name Gets or sets the name of the network interface.
 * @property networkId Gets or sets the ARM Id of the network resource to connect the virtual machine.
 * @property nicType NIC type
 * @property powerOnBoot Gets or sets the power on boot.
 */
public data class NetworkInterfaceArgs(
    public val deviceKey: Output<Int>? = null,
    public val ipSettings: Output<NicIPSettingsArgs>? = null,
    public val name: Output<String>? = null,
    public val networkId: Output<String>? = null,
    public val nicType: Output<Either<String, NICType>>? = null,
    public val powerOnBoot: Output<Either<String, PowerOnBootOption>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkInterfaceArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkInterfaceArgs.builder()
            .deviceKey(deviceKey?.applyValue({ args0 -> args0 }))
            .ipSettings(ipSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkId(networkId?.applyValue({ args0 -> args0 }))
            .nicType(
                nicType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .powerOnBoot(
                powerOnBoot?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var deviceKey: Output<Int>? = null

    private var ipSettings: Output<NicIPSettingsArgs>? = null

    private var name: Output<String>? = null

    private var networkId: Output<String>? = null

    private var nicType: Output<Either<String, NICType>>? = null

    private var powerOnBoot: Output<Either<String, PowerOnBootOption>>? = null

    /**
     * @param value Gets or sets the device key value.
     */
    @JvmName("cepaeqksinjyptkm")
    public suspend fun deviceKey(`value`: Output<Int>) {
        this.deviceKey = value
    }

    /**
     * @param value Gets or sets the ipsettings.
     */
    @JvmName("cannowyieryaiuvx")
    public suspend fun ipSettings(`value`: Output<NicIPSettingsArgs>) {
        this.ipSettings = value
    }

    /**
     * @param value Gets or sets the name of the network interface.
     */
    @JvmName("wolyucctaojeyplq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the ARM Id of the network resource to connect the virtual machine.
     */
    @JvmName("dqsogbhilgroqyhh")
    public suspend fun networkId(`value`: Output<String>) {
        this.networkId = value
    }

    /**
     * @param value NIC type
     */
    @JvmName("yjvaxdnqahqnodwn")
    public suspend fun nicType(`value`: Output<Either<String, NICType>>) {
        this.nicType = value
    }

    /**
     * @param value Gets or sets the power on boot.
     */
    @JvmName("epddgvdpeapfuqwg")
    public suspend fun powerOnBoot(`value`: Output<Either<String, PowerOnBootOption>>) {
        this.powerOnBoot = value
    }

    /**
     * @param value Gets or sets the device key value.
     */
    @JvmName("yvbcpodamqknumkp")
    public suspend fun deviceKey(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceKey = mapped
    }

    /**
     * @param value Gets or sets the ipsettings.
     */
    @JvmName("sqgkujkghkncsyje")
    public suspend fun ipSettings(`value`: NicIPSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSettings = mapped
    }

    /**
     * @param argument Gets or sets the ipsettings.
     */
    @JvmName("mrtajoatepavmxsm")
    public suspend fun ipSettings(argument: suspend NicIPSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NicIPSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipSettings = mapped
    }

    /**
     * @param value Gets or sets the name of the network interface.
     */
    @JvmName("ahruxlcnbvbxtxum")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the network resource to connect the virtual machine.
     */
    @JvmName("wcuqhnkhbrvaopjk")
    public suspend fun networkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkId = mapped
    }

    /**
     * @param value NIC type
     */
    @JvmName("plpsfetqaykvbhdm")
    public suspend fun nicType(`value`: Either<String, NICType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value NIC type
     */
    @JvmName("ekdlkmqkrqvamxpc")
    public fun nicType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NICType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value NIC type
     */
    @JvmName("wmexgffrwjcxkaoh")
    public fun nicType(`value`: NICType) {
        val toBeMapped = Either.ofRight<String, NICType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value Gets or sets the power on boot.
     */
    @JvmName("mrypvtqachsllxmi")
    public suspend fun powerOnBoot(`value`: Either<String, PowerOnBootOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerOnBoot = mapped
    }

    /**
     * @param value Gets or sets the power on boot.
     */
    @JvmName("qwksqxhecvqsfhha")
    public fun powerOnBoot(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PowerOnBootOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.powerOnBoot = mapped
    }

    /**
     * @param value Gets or sets the power on boot.
     */
    @JvmName("ownhduukghosdalu")
    public fun powerOnBoot(`value`: PowerOnBootOption) {
        val toBeMapped = Either.ofRight<String, PowerOnBootOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.powerOnBoot = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        deviceKey = deviceKey,
        ipSettings = ipSettings,
        name = name,
        networkId = networkId,
        nicType = nicType,
        powerOnBoot = powerOnBoot,
    )
}
