@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.NicIPSettingsArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.IPAddressAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the network interface ip settings.
 * @property allocationMethod Gets or sets the nic allocation method.
 * @property dnsServers Gets or sets the dns servers.
 * @property gateway Gets or sets the gateway.
 * @property ipAddress Gets or sets the ip address for the nic.
 * @property subnetMask Gets or sets the mask.
 */
public data class NicIPSettingsArgs(
    public val allocationMethod: Output<Either<String, IPAddressAllocationMethod>>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val gateway: Output<List<String>>? = null,
    public val ipAddress: Output<String>? = null,
    public val subnetMask: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.NicIPSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.NicIPSettingsArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.NicIPSettingsArgs.builder()
            .allocationMethod(
                allocationMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gateway(gateway?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .subnetMask(subnetMask?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NicIPSettingsArgs].
 */
@PulumiTagMarker
public class NicIPSettingsArgsBuilder internal constructor() {
    private var allocationMethod: Output<Either<String, IPAddressAllocationMethod>>? = null

    private var dnsServers: Output<List<String>>? = null

    private var gateway: Output<List<String>>? = null

    private var ipAddress: Output<String>? = null

    private var subnetMask: Output<String>? = null

    /**
     * @param value Gets or sets the nic allocation method.
     */
    @JvmName("hcoqjpofjsqcpmcm")
    public suspend fun allocationMethod(`value`: Output<Either<String, IPAddressAllocationMethod>>) {
        this.allocationMethod = value
    }

    /**
     * @param value Gets or sets the dns servers.
     */
    @JvmName("dhckfoiqdlbsfkbr")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("yswgsycubqssthnl")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the dns servers.
     */
    @JvmName("xdxywdvwjnvasfrt")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Gets or sets the gateway.
     */
    @JvmName("ixmgbjiouqiwkmda")
    public suspend fun gateway(`value`: Output<List<String>>) {
        this.gateway = value
    }

    @JvmName("kmleqwlwukgowrnn")
    public suspend fun gateway(vararg values: Output<String>) {
        this.gateway = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the gateway.
     */
    @JvmName("qukkllpqghfoeaxt")
    public suspend fun gateway(values: List<Output<String>>) {
        this.gateway = Output.all(values)
    }

    /**
     * @param value Gets or sets the ip address for the nic.
     */
    @JvmName("ppbuwblqjxaulfqk")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Gets or sets the mask.
     */
    @JvmName("narmkfpqjajgfqdh")
    public suspend fun subnetMask(`value`: Output<String>) {
        this.subnetMask = value
    }

    /**
     * @param value Gets or sets the nic allocation method.
     */
    @JvmName("klvxttwtwfobqccm")
    public suspend fun allocationMethod(`value`: Either<String, IPAddressAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationMethod = mapped
    }

    /**
     * @param value Gets or sets the nic allocation method.
     */
    @JvmName("hmnuenufesoqbcno")
    public fun allocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAddressAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationMethod = mapped
    }

    /**
     * @param value Gets or sets the nic allocation method.
     */
    @JvmName("otiglxdfxhsbyjew")
    public fun allocationMethod(`value`: IPAddressAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAddressAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationMethod = mapped
    }

    /**
     * @param value Gets or sets the dns servers.
     */
    @JvmName("qgiobdpqnjjkqwyv")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values Gets or sets the dns servers.
     */
    @JvmName("yhlrlcnfljxpjwsu")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Gets or sets the gateway.
     */
    @JvmName("qdnwhnxbmdclandh")
    public suspend fun gateway(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param values Gets or sets the gateway.
     */
    @JvmName("dgjoouarmpjxxokr")
    public suspend fun gateway(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param value Gets or sets the ip address for the nic.
     */
    @JvmName("bikutjipxyqkpjms")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Gets or sets the mask.
     */
    @JvmName("olubjoqnunhpkseu")
    public suspend fun subnetMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMask = mapped
    }

    internal fun build(): NicIPSettingsArgs = NicIPSettingsArgs(
        allocationMethod = allocationMethod,
        dnsServers = dnsServers,
        gateway = gateway,
        ipAddress = ipAddress,
        subnetMask = subnetMask,
    )
}
