@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileForVMInstanceArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.OsType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the operating system settings for the virtual machine.
 * @property adminPassword Sets administrator password.
 * @property adminUsername Gets or sets administrator username.
 * @property computerName Gets or sets computer name.
 * @property guestId Gets or sets the guestId.
 * @property osType Gets or sets the type of the os.
 */
public data class OsProfileForVMInstanceArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val computerName: Output<String>? = null,
    public val guestId: Output<String>? = null,
    public val osType: Output<Either<String, OsType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileForVMInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileForVMInstanceArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileForVMInstanceArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 }))
            .guestId(guestId?.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OsProfileForVMInstanceArgs].
 */
@PulumiTagMarker
public class OsProfileForVMInstanceArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var computerName: Output<String>? = null

    private var guestId: Output<String>? = null

    private var osType: Output<Either<String, OsType>>? = null

    /**
     * @param value Sets administrator password.
     */
    @JvmName("pgqlktthfukgylng")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Gets or sets administrator username.
     */
    @JvmName("shprlorxwnvqdfml")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("xgnxanocqrcuxdge")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value Gets or sets the guestId.
     */
    @JvmName("jpmgoprnbbgrjibr")
    public suspend fun guestId(`value`: Output<String>) {
        this.guestId = value
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("bavjctucdfprwulo")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value Sets administrator password.
     */
    @JvmName("dihkxengmkhvxojm")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Gets or sets administrator username.
     */
    @JvmName("cdnjromaxwupohge")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("uemvuyvqtjqgaegr")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    /**
     * @param value Gets or sets the guestId.
     */
    @JvmName("uylkeeqndhkydinp")
    public suspend fun guestId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestId = mapped
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("xugnrwqrkoutatal")
    public suspend fun osType(`value`: Either<String, OsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("pmdtfbwosjncqacw")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("hysqamxshxgkfbkb")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    internal fun build(): OsProfileForVMInstanceArgs = OsProfileForVMInstanceArgs(
        adminPassword = adminPassword,
        adminUsername = adminUsername,
        computerName = computerName,
        guestId = guestId,
        osType = osType,
    )
}
