@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.PlacementProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the compute and storage placement settings for the virtual machine.
 * @property clusterId Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
 * @property datastoreId Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
 * @property hostId Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
 * @property resourcePoolId Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
 */
public data class PlacementProfileArgs(
    public val clusterId: Output<String>? = null,
    public val datastoreId: Output<String>? = null,
    public val hostId: Output<String>? = null,
    public val resourcePoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.PlacementProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.PlacementProfileArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.PlacementProfileArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .datastoreId(datastoreId?.applyValue({ args0 -> args0 }))
            .hostId(hostId?.applyValue({ args0 -> args0 }))
            .resourcePoolId(resourcePoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlacementProfileArgs].
 */
@PulumiTagMarker
public class PlacementProfileArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var datastoreId: Output<String>? = null

    private var hostId: Output<String>? = null

    private var resourcePoolId: Output<String>? = null

    /**
     * @param value Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
     */
    @JvmName("txgittbfbpoviseo")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
     */
    @JvmName("yhgtpmnnfcnvtvcv")
    public suspend fun datastoreId(`value`: Output<String>) {
        this.datastoreId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
     */
    @JvmName("ugnpfqwgxwapesny")
    public suspend fun hostId(`value`: Output<String>) {
        this.hostId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
     */
    @JvmName("vwoudvjrvibptoru")
    public suspend fun resourcePoolId(`value`: Output<String>) {
        this.resourcePoolId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
     */
    @JvmName("aumayxxxgjwbyjkg")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
     */
    @JvmName("dfiwfdyxjsfvfvwk")
    public suspend fun datastoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
     */
    @JvmName("nolhktmysmuqftui")
    public suspend fun hostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
     */
    @JvmName("frjjsflnqdwvmnwf")
    public suspend fun resourcePoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePoolId = mapped
    }

    internal fun build(): PlacementProfileArgs = PlacementProfileArgs(
        clusterId = clusterId,
        datastoreId = datastoreId,
        hostId = hostId,
        resourcePoolId = resourcePoolId,
    )
}
