@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.VirtualDiskArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.DiskMode
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.DiskType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual disk model
 * @property controllerKey Gets or sets the controller id.
 * @property deviceKey Gets or sets the device key value.
 * @property deviceName Gets or sets the device name.
 * @property diskMode Gets or sets the disk mode.
 * @property diskSizeGB Gets or sets the disk total size.
 * @property diskType Gets or sets the disk backing type.
 * @property name Gets or sets the name of the virtual disk.
 * @property unitNumber Gets or sets the unit number of the disk on the controller.
 */
public data class VirtualDiskArgs(
    public val controllerKey: Output<Int>? = null,
    public val deviceKey: Output<Int>? = null,
    public val deviceName: Output<String>? = null,
    public val diskMode: Output<Either<String, DiskMode>>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val diskType: Output<Either<String, DiskType>>? = null,
    public val name: Output<String>? = null,
    public val unitNumber: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.VirtualDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.VirtualDiskArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.VirtualDiskArgs.builder()
            .controllerKey(controllerKey?.applyValue({ args0 -> args0 }))
            .deviceKey(deviceKey?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .diskMode(
                diskMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .unitNumber(unitNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualDiskArgs].
 */
@PulumiTagMarker
public class VirtualDiskArgsBuilder internal constructor() {
    private var controllerKey: Output<Int>? = null

    private var deviceKey: Output<Int>? = null

    private var deviceName: Output<String>? = null

    private var diskMode: Output<Either<String, DiskMode>>? = null

    private var diskSizeGB: Output<Int>? = null

    private var diskType: Output<Either<String, DiskType>>? = null

    private var name: Output<String>? = null

    private var unitNumber: Output<Int>? = null

    /**
     * @param value Gets or sets the controller id.
     */
    @JvmName("owtxdmevqqcsdtbd")
    public suspend fun controllerKey(`value`: Output<Int>) {
        this.controllerKey = value
    }

    /**
     * @param value Gets or sets the device key value.
     */
    @JvmName("whmwuosyotvbdotl")
    public suspend fun deviceKey(`value`: Output<Int>) {
        this.deviceKey = value
    }

    /**
     * @param value Gets or sets the device name.
     */
    @JvmName("nxqkqajovtoqdpif")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Gets or sets the disk mode.
     */
    @JvmName("jwmjwvffxandvehp")
    public suspend fun diskMode(`value`: Output<Either<String, DiskMode>>) {
        this.diskMode = value
    }

    /**
     * @param value Gets or sets the disk total size.
     */
    @JvmName("siipownaygfwjjbh")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Gets or sets the disk backing type.
     */
    @JvmName("ajfivjklpfygdipi")
    public suspend fun diskType(`value`: Output<Either<String, DiskType>>) {
        this.diskType = value
    }

    /**
     * @param value Gets or sets the name of the virtual disk.
     */
    @JvmName("fbnghiaeagyyrimf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the unit number of the disk on the controller.
     */
    @JvmName("lkqrrhthehycikfo")
    public suspend fun unitNumber(`value`: Output<Int>) {
        this.unitNumber = value
    }

    /**
     * @param value Gets or sets the controller id.
     */
    @JvmName("lhgivasuvpxndboo")
    public suspend fun controllerKey(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controllerKey = mapped
    }

    /**
     * @param value Gets or sets the device key value.
     */
    @JvmName("vqxxjtcnurscdbvk")
    public suspend fun deviceKey(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceKey = mapped
    }

    /**
     * @param value Gets or sets the device name.
     */
    @JvmName("jorjtrdglllbbprt")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Gets or sets the disk mode.
     */
    @JvmName("xsjhqeaboolimnvc")
    public suspend fun diskMode(`value`: Either<String, DiskMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskMode = mapped
    }

    /**
     * @param value Gets or sets the disk mode.
     */
    @JvmName("vwahqwhutiirigjc")
    public fun diskMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskMode = mapped
    }

    /**
     * @param value Gets or sets the disk mode.
     */
    @JvmName("weodxopnbatkeiad")
    public fun diskMode(`value`: DiskMode) {
        val toBeMapped = Either.ofRight<String, DiskMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskMode = mapped
    }

    /**
     * @param value Gets or sets the disk total size.
     */
    @JvmName("mkqueoaepqybxsye")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Gets or sets the disk backing type.
     */
    @JvmName("pfkwrqgnjcaajmrm")
    public suspend fun diskType(`value`: Either<String, DiskType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Gets or sets the disk backing type.
     */
    @JvmName("ubkxyarvkwlotvat")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Gets or sets the disk backing type.
     */
    @JvmName("ghiypkcreycoxwhf")
    public fun diskType(`value`: DiskType) {
        val toBeMapped = Either.ofRight<String, DiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Gets or sets the name of the virtual disk.
     */
    @JvmName("ssjwnkjuyslyrlvf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the unit number of the disk on the controller.
     */
    @JvmName("plmeueiwxbsnvjrw")
    public suspend fun unitNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unitNumber = mapped
    }

    internal fun build(): VirtualDiskArgs = VirtualDiskArgs(
        controllerKey = controllerKey,
        deviceKey = deviceKey,
        deviceName = deviceName,
        diskMode = diskMode,
        diskSizeGB = diskSizeGB,
        diskType = diskType,
        name = name,
        unitNumber = unitNumber,
    )
}
