@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the datastore.
 * @property capacityGB Gets or sets Maximum capacity of this datastore in GBs.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property extendedLocation Gets or sets the extended location.
 * @property freeSpaceGB Gets or sets Available space of this datastore in GBs.
 * @property id Gets or sets the Id.
 * @property inventoryItemId Gets or sets the inventory Item ID for the datastore.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property moName Gets or sets the vCenter Managed Object name for the datastore.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the datastore.
 * @property name Gets or sets the name.
 * @property provisioningState Provisioning state of the resource.
 * @property statuses The resource status information.
 * @property systemData The system data.
 * @property tags Gets or sets the Resource tags.
 * @property type Gets or sets the type of the resource.
 * @property uuid Gets or sets a unique identifier for this resource.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this datastore resides.
 */
public data class GetDatastoreResult(
    public val capacityGB: Double,
    public val customResourceName: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val freeSpaceGB: Double,
    public val id: String,
    public val inventoryItemId: String? = null,
    public val kind: String? = null,
    public val location: String,
    public val moName: String,
    public val moRefId: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val statuses: List<ResourceStatusResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String,
    public val vCenterId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetDatastoreResult): GetDatastoreResult = GetDatastoreResult(
            capacityGB = javaType.capacityGB(),
            customResourceName = javaType.customResourceName(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            freeSpaceGB = javaType.freeSpaceGB(),
            id = javaType.id(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            moName = javaType.moName(),
            moRefId = javaType.moRefId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid(),
            vCenterId = javaType.vCenterId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
