@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the inventory item.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property inventoryType They inventory type.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property managedResourceId Gets or sets the tracked resource id corresponding to the inventory resource.
 * @property moName Gets or sets the vCenter Managed Object name for the inventory item.
 * @property moRefId Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
 * @property name The name of the resource
 * @property provisioningState Gets or sets the provisioning state.
 * @property systemData The system data.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetInventoryItemResult(
    public val id: String,
    public val inventoryType: String,
    public val kind: String? = null,
    public val managedResourceId: String? = null,
    public val moName: String? = null,
    public val moRefId: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetInventoryItemResult): GetInventoryItemResult = GetInventoryItemResult(
            id = javaType.id(),
            inventoryType = javaType.inventoryType(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            managedResourceId = javaType.managedResourceId().map({ args0 -> args0 }).orElse(null),
            moName = javaType.moName().map({ args0 -> args0 }).orElse(null),
            moRefId = javaType.moRefId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
