@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the GuestAgent.
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property privateLinkScopeResourceId The resource id of the private link scope this machine is assigned to, if any.
 * @property provisioningAction Gets or sets the guest agent provisioning action.
 * @property provisioningState Gets the provisioning state.
 * @property status Gets or sets the guest agent status.
 * @property statuses The resource status information.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uuid Gets or sets a unique identifier for this resource.
 */
public data class GetVMInstanceGuestAgentResult(
    public val credentials: GuestCredentialResponse? = null,
    public val customResourceName: String,
    public val httpProxyConfig: HttpProxyConfigurationResponse? = null,
    public val id: String,
    public val name: String,
    public val privateLinkScopeResourceId: String? = null,
    public val provisioningAction: String? = null,
    public val provisioningState: String,
    public val status: String,
    public val statuses: List<ResourceStatusResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetVMInstanceGuestAgentResult): GetVMInstanceGuestAgentResult = GetVMInstanceGuestAgentResult(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GuestCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customResourceName = javaType.customResourceName(),
            httpProxyConfig = javaType.httpProxyConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HttpProxyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            privateLinkScopeResourceId = javaType.privateLinkScopeResourceId().map({ args0 ->
                args0
            }).orElse(null),
            provisioningAction = javaType.provisioningAction().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uuid = javaType.uuid(),
        )
    }
}
