@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Define the virtualMachineInstance.
 * @property extendedLocation Gets or sets the extended location.
 * @property hardwareProfile Hardware properties.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property infrastructureProfile Gets the infrastructure profile.
 * @property name The name of the resource
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property placementProfile Placement properties.
 * @property powerState Gets the power state of the virtual machine.
 * @property provisioningState Gets the provisioning state.
 * @property resourceUid Gets or sets a unique identifier for the vm resource.
 * @property securityProfile Gets the security profile.
 * @property statuses The resource status information.
 * @property storageProfile Storage properties.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVirtualMachineInstanceResult(
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val id: String,
    public val infrastructureProfile: InfrastructureProfileResponse? = null,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val osProfile: OsProfileForVMInstanceResponse? = null,
    public val placementProfile: PlacementProfileResponse? = null,
    public val powerState: String,
    public val provisioningState: String,
    public val resourceUid: String,
    public val securityProfile: SecurityProfileResponse? = null,
    public val statuses: List<ResourceStatusResponse>,
    public val storageProfile: StorageProfileResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetVirtualMachineInstanceResult): GetVirtualMachineInstanceResult = GetVirtualMachineInstanceResult(
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            infrastructureProfile = javaType.infrastructureProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.InfrastructureProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileForVMInstanceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            placementProfile = javaType.placementProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.PlacementProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            resourceUid = javaType.resourceUid(),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
