@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the guest agent settings for the virtual machine.
 * @property agentVersion The hybrid machine agent full version.
 * @property clientPublicKey Gets or sets the Public Key provided by the client for enabling guest management.
 * @property errorDetails Details about the error state.
 * @property lastStatusChange The time of the last status change.
 * @property mssqlDiscovered Specifies whether any MS SQL instance is discovered on the machine.
 * @property status The status of the hybrid machine agent.
 * @property vmUuid Specifies the VM's unique SMBIOS ID.
 */
public data class GuestAgentProfileResponse(
    public val agentVersion: String,
    public val clientPublicKey: String? = null,
    public val errorDetails: List<ErrorDetailResponse>,
    public val lastStatusChange: String,
    public val mssqlDiscovered: String,
    public val status: String,
    public val vmUuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GuestAgentProfileResponse): GuestAgentProfileResponse = GuestAgentProfileResponse(
            agentVersion = javaType.agentVersion(),
            clientPublicKey = javaType.clientPublicKey().map({ args0 -> args0 }).orElse(null),
            errorDetails = javaType.errorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }),
            lastStatusChange = javaType.lastStatusChange(),
            mssqlDiscovered = javaType.mssqlDiscovered(),
            status = javaType.status(),
            vmUuid = javaType.vmUuid(),
        )
    }
}
