@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network Interface model
 * @property deviceKey Gets or sets the device key value.
 * @property ipAddresses Gets or sets the nic ip addresses.
 * @property ipSettings Gets or sets the ipsettings.
 * @property label Gets or sets the label of the virtual network in vCenter that the nic is connected to.
 * @property macAddress Gets or sets the NIC MAC address.
 * @property name Gets or sets the name of the network interface.
 * @property networkId Gets or sets the ARM Id of the network resource to connect the virtual machine.
 * @property networkMoName Gets or sets the name of the virtual network in vCenter that the nic is connected to.
 * @property networkMoRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID of the virtual network
 * that the nic is connected to.
 * @property nicType NIC type
 * @property powerOnBoot Gets or sets the power on boot.
 */
public data class NetworkInterfaceResponse(
    public val deviceKey: Int? = null,
    public val ipAddresses: List<String>,
    public val ipSettings: NicIPSettingsResponse? = null,
    public val label: String,
    public val macAddress: String,
    public val name: String? = null,
    public val networkId: String? = null,
    public val networkMoName: String,
    public val networkMoRefId: String,
    public val nicType: String? = null,
    public val powerOnBoot: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.NetworkInterfaceResponse): NetworkInterfaceResponse = NetworkInterfaceResponse(
            deviceKey = javaType.deviceKey().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            ipSettings = javaType.ipSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NicIPSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            label = javaType.label(),
            macAddress = javaType.macAddress(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkId = javaType.networkId().map({ args0 -> args0 }).orElse(null),
            networkMoName = javaType.networkMoName(),
            networkMoRefId = javaType.networkMoRefId(),
            nicType = javaType.nicType().map({ args0 -> args0 }).orElse(null),
            powerOnBoot = javaType.powerOnBoot().map({ args0 -> args0 }).orElse(null),
        )
    }
}
