@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP address information for a virtual network adapter reported by the fabric.
 * @property allocationMethod Gets the ip address allocation method.
 * @property ipAddress Gets the ip address for the nic.
 * @property subnetMask Gets the mask.
 */
public data class NicIPAddressSettingsResponse(
    public val allocationMethod: String,
    public val ipAddress: String,
    public val subnetMask: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.NicIPAddressSettingsResponse): NicIPAddressSettingsResponse = NicIPAddressSettingsResponse(
            allocationMethod = javaType.allocationMethod(),
            ipAddress = javaType.ipAddress(),
            subnetMask = javaType.subnetMask(),
        )
    }
}
