@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the operating system settings for the virtual machine.
 * @property adminUsername Gets or sets administrator username.
 * @property allowExtensionOperations Gets or sets a value indicating whether the VM is ready for extension operations.
 * @property computerName Gets or sets computer name.
 * @property guestId Gets or sets the guestId.
 * @property linuxConfiguration Specifies the linux configuration for update management.
 * @property osName Gets or sets os name.
 * @property osType Gets or sets the type of the os.
 * @property toolsRunningStatus Gets or sets the current running status of VMware Tools running in the guest operating system.
 * @property toolsVersion Gets or sets the current version of VMware Tools.
 * @property toolsVersionStatus Gets or sets the current version status of VMware Tools installed in the guest operating system.
 * @property windowsConfiguration Specifies the windows configuration for update management.
 */
public data class OsProfileResponse(
    public val adminUsername: String? = null,
    public val allowExtensionOperations: Boolean,
    public val computerName: String? = null,
    public val guestId: String? = null,
    public val linuxConfiguration: OsProfileResponseLinuxConfiguration? = null,
    public val osName: String,
    public val osType: String? = null,
    public val toolsRunningStatus: String,
    public val toolsVersion: String,
    public val toolsVersionStatus: String,
    public val windowsConfiguration: OsProfileResponseWindowsConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.OsProfileResponse): OsProfileResponse = OsProfileResponse(
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            allowExtensionOperations = javaType.allowExtensionOperations(),
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            guestId = javaType.guestId().map({ args0 -> args0 }).orElse(null),
            linuxConfiguration = javaType.linuxConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileResponseLinuxConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osName = javaType.osName(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            toolsRunningStatus = javaType.toolsRunningStatus(),
            toolsVersion = javaType.toolsVersion(),
            toolsVersionStatus = javaType.toolsVersionStatus(),
            windowsConfiguration = javaType.windowsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileResponseWindowsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
