@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the compute and storage placement settings for the virtual machine.
 * @property clusterId Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
 * @property datastoreId Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
 * @property hostId Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
 * @property resourcePoolId Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
 */
public data class PlacementProfileResponse(
    public val clusterId: String? = null,
    public val datastoreId: String? = null,
    public val hostId: String? = null,
    public val resourcePoolId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.PlacementProfileResponse): PlacementProfileResponse = PlacementProfileResponse(
            clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
            datastoreId = javaType.datastoreId().map({ args0 -> args0 }).orElse(null),
            hostId = javaType.hostId().map({ args0 -> args0 }).orElse(null),
            resourcePoolId = javaType.resourcePoolId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
