@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the storage settings for the virtual machine disks.
 * @property disks Gets or sets the list of virtual disks associated with the virtual machine.
 * @property scsiControllers Gets or sets the list of virtual SCSI controllers associated with the virtual machine.
 */
public data class StorageProfileResponse(
    public val disks: List<VirtualDiskResponse>? = null,
    public val scsiControllers: List<VirtualSCSIControllerResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.StorageProfileResponse): StorageProfileResponse = StorageProfileResponse(
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin(args0)
                })
            }),
            scsiControllers = javaType.scsiControllers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.VirtualSCSIControllerResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
